import pandas as pd  
import matplotlib.pyplot as plt  
from decision_company import read_csv_file, get_fig_from_df, count_unique_values, set_layout, bind_dataframe, pivot_a_level, fill_missing_values, create_subplots, show_plots, save_plot, logical_and, filter_by_condition, make_bins

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Calculate approval rates  
credit_history_group = bind_dataframe(credit_customers, 'credit_history')  
credit_history_counts = count_unique_values(credit_history_group['class'], normalize=True)  
approval_rates_credit_history = fill_missing_values(pivot_a_level(credit_history_counts), value=0)['good']  
  
employment_group = bind_dataframe(credit_customers, 'employment')  
employment_counts = count_unique_values(employment_group['class'], normalize=True)  
approval_rates_employment = fill_missing_values(pivot_a_level(employment_counts), value=0)['good']  
  
age_column = credit_customers['age']  
middle_age_condition = logical_and(age_column > 40, age_column < 59)  
middle_age_customers = filter_by_condition(credit_customers, middle_age_condition)  
middle_age_group = bind_dataframe(middle_age_customers, 'age')  
middle_age_counts = count_unique_values(middle_age_group['class'], normalize=True)  
approval_rates_middle_age = fill_missing_values(pivot_a_level(middle_age_counts), value=0)['good']  
  
credit_customers['credit_amount_range'] = make_bins(credit_customers['credit_amount'], bins=[0, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000, 18000, 20000], include_lowest=True)  
credit_amount_group = bind_dataframe(credit_customers, 'credit_amount_range')  
credit_amount_counts = count_unique_values(credit_amount_group['class'], normalize=True)  
approval_rates_credit_amount = fill_missing_values(pivot_a_level(credit_amount_counts), value=0)['good']  
  
# Plot bar charts  
fig, axes = create_subplots(2, 2, figsize=(12, 8))  
  
get_fig_from_df(approval_rates_credit_history, kind='bar', ax=axes[0, 0], title='Approval Rates by Credit History')  
get_fig_from_df(approval_rates_employment, kind='bar', ax=axes[0, 1], title='Approval Rates by Employment Status')  
get_fig_from_df(approval_rates_middle_age, kind='bar', ax=axes[1, 0], title='Approval Rates for Middle-Age Group (40-59)')  
get_fig_from_df(approval_rates_credit_amount, kind='bar', ax=axes[1, 1], title='Approval Rates by Credit Amount Range')  
  
set_layout()  
save_plot('ref_result/bar_chart.png')  
show_plots()  
